 /****** Object:  StoredProcedure [dbo].[P_EST_PROD_CUSTO_ACERTO_REPLICACAO]    Script Date: 03/26/2014 10:46:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CUSTO_ACERTO_REPLICACAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CUSTO_ACERTO_REPLICACAO]
GO
--EXEC P_EST_PROD_CUSTO_ACERTO_REPLICACAO 1,90,65177,'2015-01-01',9.10,1,0
CREATE PROCEDURE P_EST_PROD_CUSTO_ACERTO_REPLICACAO (@CD_EMP INT,
										   @CD_FILIAL INT,
										   @CD_PROD INT,
										   @DT_PROC DATETIME,
										   @VLR_PROD_CUSTO MONEY,
										   @CD_USU INT,
										   @TP_ANALISE INT,
										   @TP_AJUSTE INT=0,
										   @QT_AJUSTE MONEY=0,
										   @GrossUP TinyInt=0) AS

------------------------------------------------------------------------------------------
DELETE FROM EST_PROD_CPL_ACERTO_CUSTO
WHERE
      CD_EMP = @CD_EMP
      AND CD_FILIAL = @CD_FILIAL
      AND CD_PROD = @CD_PROD
      AND DT_MOV >= @DT_PROC;
------------------------------------------------------------------------------------------

UPDATE EST_PROD_CPL
  SET
      EST_PROD_CPL.VLR_CUSTO_GER = @VLR_PROD_CUSTO
    , EST_PROD_CPL.VLR_CUSTO_MD = @VLR_PROD_CUSTO
    , EST_PROD_CPL.VLR_CUSTO = @VLR_PROD_CUSTO
    , EST_PROD_CPL.VLR_CUSTO_MD_FLUTUANTE = @VLR_PROD_CUSTO
WHERE
      EST_PROD_CPL.CD_EMP = @CD_EMP
      AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
      AND EST_PROD_CPL.CD_PROD = @CD_PROD;	

-----------------------------------------------------------------------------------------------

UPDATE EST_PROD_TRANSF_IT
  SET
      EST_PROD_TRANSF_IT.VLR_CUSTO = @VLR_PROD_CUSTO
FROM EST_PROD_TRANSF
     INNER JOIN EST_PROD_TRANSF_IT ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_IT.CD_EMP
                                      AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_IT.CD_FILIAL
                                      AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_IT.CD_CTR
     INNER JOIN EST_PROD_CPL ON EST_PROD_TRANSF_IT.CD_EMP = EST_PROD_CPL.CD_EMP
                                AND EST_PROD_TRANSF_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
                                AND EST_PROD_TRANSF_IT.CD_PROD = EST_PROD_CPL.CD_PROD
     INNER JOIN EST_PROD_TRANSF_PENDENCIA ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_PENDENCIA.CD_EMP
                                             AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_PENDENCIA.CD_FILIAL
                                             AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_PENDENCIA.CD_CTR
WHERE
      EST_PROD_TRANSF_IT.CD_EMP = @CD_EMP
      AND EST_PROD_TRANSF_IT.CD_FILIAL = @CD_FILIAL
      AND EST_PROD_TRANSF_IT.VLR_CUSTO = 0
      AND EST_PROD_TRANSF_IT.CD_PROD = @CD_PROD;
-----------------------------------------------------------------------------------------------	  
	  	
DELETE FROM T
FROM EST_PROD_TRANSF_ERROS_VALIDACAO T
     INNER JOIN EST_PROD_TRANSF_IT ON T.CD_EMP = EST_PROD_TRANSF_IT.CD_EMP
                                      AND T.CD_FILIAL = EST_PROD_TRANSF_IT.CD_FILIAL
                                      AND T.CD_CTR = EST_PROD_TRANSF_IT.CD_CTR
     INNER JOIN EST_PROD_TRANSF_PENDENCIA ON T.CD_EMP = EST_PROD_TRANSF_PENDENCIA.CD_EMP
                                             AND T.CD_FILIAL = EST_PROD_TRANSF_PENDENCIA.CD_FILIAL
                                             AND T.CD_CTR = EST_PROD_TRANSF_PENDENCIA.CD_CTR
WHERE
      EST_PROD_TRANSF_IT.CD_EMP = @CD_EMP
      AND EST_PROD_TRANSF_IT.CD_FILIAL = @CD_FILIAL
      AND EST_PROD_TRANSF_IT.VLR_CUSTO = 0
      AND EST_PROD_TRANSF_IT.CD_PROD = @CD_PROD;	

-----------------------------------------------------------------------------------------------	  

UPDATE EST_PED_VD_IT
  SET
      EST_PED_VD_IT.VLR_IT = @VLR_PROD_CUSTO
FROM EST_PED_VD_IT
     INNER JOIN EST_PROD_CPL ON EST_PED_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP
                                AND EST_PED_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
                                AND EST_PED_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
     INNER JOIN EST_PED_VD_PENDENCIA ON EST_PED_VD_IT.CD_EMP = EST_PED_VD_PENDENCIA.CD_EMP
                                        AND EST_PED_VD_IT.CD_FILIAL = EST_PED_VD_PENDENCIA.CD_FILIAL
                                        AND EST_PED_VD_IT.CD_PED = EST_PED_VD_PENDENCIA.CD_PED
WHERE
      EST_PED_VD_IT.CD_EMP = @CD_EMP
      AND EST_PED_VD_IT.CD_FILIAL = @CD_FILIAL
      AND EST_PED_VD_IT.VLR_IT = 0
      AND EST_PED_VD_IT.CD_PROD = @CD_PROD;

-----------------------------------------------------------------------------------------------	  

DELETE FROM P
FROM EST_PED_VD_IT
     INNER JOIN EST_PED_VD_ERROS_VALIDACAO P ON EST_PED_VD_IT.CD_EMP = P.CD_EMP
                                                AND EST_PED_VD_IT.CD_FILIAL = P.CD_FILIAL
                                                AND EST_PED_VD_IT.CD_PED = P.CD_PED
     INNER JOIN EST_PED_VD_PENDENCIA ON EST_PED_VD_IT.CD_EMP = EST_PED_VD_PENDENCIA.CD_EMP
                                        AND EST_PED_VD_IT.CD_FILIAL = EST_PED_VD_PENDENCIA.CD_FILIAL
                                        AND EST_PED_VD_IT.CD_PED = EST_PED_VD_PENDENCIA.CD_PED
WHERE
      EST_PED_VD_IT.CD_EMP = @CD_EMP
      AND EST_PED_VD_IT.CD_FILIAL = @CD_FILIAL
      AND EST_PED_VD_IT.VLR_IT = 0
      AND EST_PED_VD_IT.CD_PROD = @CD_PROD;
-----------------------------------------------------------------------------------------------	  
	
IF @TP_ANALISE = 1
    BEGIN
        SELECT
               EST_NF_SAI_IT.CD_EMP
             , EST_NF_SAI_IT.CD_FILIAL
             , EST_NF_SAI_IT.CD_PROD
             , ISNULL(EST_NF_SAI_IT.VLR_CUSTO_ACERTO, 0) AS VLR_CUSTO_ACERTO
             , EST_NF_SAI_IT.VLR_IT
             , 'NOTA SAIDA PENDENTE ENTRADA' AS TIPO_REGISTRO
        FROM
             EST_NF_SAI
             INNER JOIN EST_NF_SAI_IT ON EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP
                                         AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
                                         AND EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF
             INNER JOIN EST_NF_SAI_PENDENCIA ON EST_NF_SAI.CD_EMP = EST_NF_SAI_PENDENCIA.CD_EMP
                                                AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_PENDENCIA.CD_FILIAL
                                                AND EST_NF_SAI.CD_NF = EST_NF_SAI_PENDENCIA.CD_NF
        WHERE EST_NF_SAI.CD_EMP = @CD_EMP
              AND EST_NF_SAI.CD_FILIAL = @CD_FILIAL
              AND EST_NF_SAI.DT_EMI_NF >= @DT_PROC
              AND EST_NF_SAI_IT.CD_PROD = @CD_PROD
              AND ROUND(EST_NF_SAI_IT.VLR_IT, 2) <> @VLR_PROD_CUSTO
        UNION ALL
        SELECT
               EST_NF_ENT_IT.CD_EMP
             , EST_NF_ENT_IT.CD_FILIAL
             , EST_NF_ENT_IT.CD_PROD
             , ISNULL(EST_NF_ENT_IT.VLR_CUSTO_ACERTO, 0)
             , EST_NF_ENT_IT.VLR_PRC_CUSTO
             , 'NOTA ENTRADA' AS TIPO_REGISTRO
        FROM
             EST_NF_ENT
             INNER JOIN EST_NF_ENT_IT ON EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
                                         AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
                                         AND EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF
             INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP
                                                        AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST
                                                        AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT
             INNER JOIN GLB_MOV_OP ON EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
        WHERE EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP = @CD_EMP
              AND EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG = @CD_FILIAL
              AND EST_NF_ENT.DT_ENT >= @DT_PROC
              AND EST_NF_ENT_IT.CD_PROD = @CD_PROD
              AND ROUND(EST_NF_ENT_IT.VLR_PRC_CUSTO, 2) <> @VLR_PROD_CUSTO
              AND GLB_MOV_OP.ATU_EST = 1
        UNION ALL
        SELECT
               EST_PROD_TRANSF_IT.CD_EMP
             , EST_PROD_TRANSF_IT.CD_FILIAL
             , EST_PROD_TRANSF_IT.CD_PROD
             , ISNULL(EST_PROD_TRANSF_IT.VLR_CUSTO_ACERTO, 0)
             , EST_PROD_TRANSF_IT.VLR_CUSTO
             , 'RESSUPRIMENTO PENDENTE' AS TIPO_REGISTRO
        FROM
             EST_PROD_TRANSF
             INNER JOIN EST_PROD_TRANSF_IT ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_IT.CD_EMP
                                              AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_IT.CD_FILIAL
                                              AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_IT.CD_CTR
             INNER JOIN EST_PROD_TRANSF_PENDENCIA ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_PENDENCIA.CD_EMP
                                                     AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_PENDENCIA.CD_FILIAL
                                                     AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_PENDENCIA.CD_CTR
        WHERE EST_PROD_TRANSF.CD_EMP = @CD_EMP
              AND EST_PROD_TRANSF.CD_FILIAL = @CD_FILIAL
              AND EST_PROD_TRANSF.DT_TRANSF >= @DT_PROC
              AND EST_PROD_TRANSF_IT.CD_PROD = @CD_PROD
              AND ROUND(EST_PROD_TRANSF_IT.VLR_CUSTO, 2) <> @VLR_PROD_CUSTO
        UNION ALL
        SELECT
               EST_PED_VD_IT.CD_EMP
             , EST_PED_VD_IT.CD_FILIAL
             , EST_PED_VD_IT.CD_PROD
             , ISNULL(EST_PED_VD_IT.VLR_CUSTO_ACERTO, 0)
             , EST_PED_VD_IT.VLR_CUSTO
             , 'PRE-FATURA PENDENTE' AS TIPO_REGISTRO
        FROM
             EST_PED_VD
             INNER JOIN EST_PED_VD_IT ON EST_PED_VD.CD_EMP = EST_PED_VD_IT.CD_EMP
                                         AND EST_PED_VD.CD_FILIAL = EST_PED_VD_IT.CD_FILIAL
                                         AND EST_PED_VD.CD_PED = EST_PED_VD_IT.CD_PED
             INNER JOIN EST_PED_VD_PENDENCIA ON EST_PED_VD.CD_EMP = EST_PED_VD_PENDENCIA.CD_EMP
                                                AND EST_PED_VD.CD_FILIAL = EST_PED_VD_PENDENCIA.CD_FILIAL
                                                AND EST_PED_VD.CD_PED = EST_PED_VD_PENDENCIA.CD_PED
        WHERE EST_PED_VD.CD_EMP = @CD_EMP
              AND EST_PED_VD.CD_FILIAL = @CD_FILIAL
              AND EST_PED_VD.DT_EMI_PED >= @DT_PROC
              AND EST_PED_VD_IT.CD_PROD = @CD_PROD
              AND ROUND(EST_PED_VD_IT.VLR_CUSTO, 2) <> @VLR_PROD_CUSTO;
    END;

-----------------------------------------------------------------------------------------------	  

IF @TP_ANALISE = 0
    BEGIN
        DECLARE @CdCtr AS INT;
        IF EXISTS
(
    SELECT
           CD_CTR
    FROM
         EST_PROD_CPL_ACERTO_CUSTO
    WHERE CD_EMP = @CD_EMP
          AND CD_FILIAL = @CD_FILIAL
          AND CD_PROD = @CD_PROD
          AND DT_MOV = @DT_PROC
)
            BEGIN
                DELETE FROM EST_PROD_CPL_ACERTO_CUSTO
                WHERE
                      CD_EMP = @CD_EMP
                      AND CD_FILIAL = @CD_FILIAL
                      AND CD_PROD = @CD_PROD
                      AND DT_MOV = @DT_PROC;
            END;
        SELECT
               @CdCtr = ISNULL(MAX(CD_CTR), 0) + 1
        FROM
             EST_PROD_CPL_ACERTO_CUSTO;
        IF @CdCtr > 0
            BEGIN

	--@TP_AJUSTE
	-- 0 MANUAL
	-- 1 ACERTO/ESTORNO NF
	-- 2 MOVIMENTACAO 
                INSERT INTO EST_PROD_CPL_ACERTO_CUSTO
(
                       CD_CTR
                     , CD_EMP
                     , CD_FILIAL
                     , CD_PROD
                     , VLR_CUSTO_ACERTO
                     , CD_USU
                     , DT_MOV
                     , DT_CAD
                     , TP_AJUSTE
                     , QT_AJUSTE
)
                       SELECT
                              @CDCTR
                            , @CD_EMP
                            , @CD_FILIAL
                            , @CD_PROD
                            , @VLR_PROD_CUSTO
                            , @CD_USU
                            , @DT_PROC
                            , GETDATE()
                            , @TP_AJUSTE
                            , @QT_AJUSTE;

--Acertando estoque filial
                UPDATE EST_PROD_CPL
                  SET
                      EST_PROD_CPL.VLR_CUSTO_GER = @VLR_PROD_CUSTO
                    , EST_PROD_CPL.VLR_CUSTO_MD = @VLR_PROD_CUSTO
                    , EST_PROD_CPL.VLR_CUSTO = @VLR_PROD_CUSTO
                    , EST_PROD_CPL.VLR_CUSTO_MD_FLUTUANTE = @VLR_PROD_CUSTO
                WHERE
                      EST_PROD_CPL.CD_EMP = @CD_EMP
                      AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
                      AND EST_PROD_CPL.CD_PROD = @CD_PROD;				

	--Replicando para notas fiscais em transito	
                UPDATE EST_NF_SAI_IT
                  SET
                      EST_NF_SAI_IT.VLR_CUSTO_ACERTO = @VLR_PROD_CUSTO
                FROM EST_NF_SAI
                     INNER JOIN EST_NF_SAI_IT ON EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP
                                                 AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
                                                 AND EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF
                     INNER JOIN EST_NF_SAI_PENDENCIA ON EST_NF_SAI.CD_EMP = EST_NF_SAI_PENDENCIA.CD_EMP
                                                        AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_PENDENCIA.CD_FILIAL
                                                        AND EST_NF_SAI.CD_NF = EST_NF_SAI_PENDENCIA.CD_NF
                WHERE
                      EST_NF_SAI.CD_EMP = @CD_EMP
                      AND EST_NF_SAI.CD_FILIAL = @CD_FILIAL
                      AND EST_NF_SAI.DT_EMI_NF >= @DT_PROC
                      AND EST_NF_SAI_IT.CD_PROD = @CD_PROD
                      AND ROUND(EST_NF_SAI_IT.VLR_IT, 2) <> @VLR_PROD_CUSTO;

--Ressuprimento pendente
                UPDATE EST_PROD_TRANSF_IT
                  SET
                      EST_PROD_TRANSF_IT.VLR_CUSTO_ACERTO = @VLR_PROD_CUSTO
                FROM EST_PROD_TRANSF
                     INNER JOIN EST_PROD_TRANSF_IT ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_IT.CD_EMP
                                                      AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_IT.CD_FILIAL
                                                      AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_IT.CD_CTR
                     INNER JOIN EST_PROD_TRANSF_PENDENCIA ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_PENDENCIA.CD_EMP
                                                             AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_PENDENCIA.CD_FILIAL
                                                             AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_PENDENCIA.CD_CTR
                WHERE
                      EST_PROD_TRANSF.CD_EMP = @CD_EMP
                      AND EST_PROD_TRANSF.CD_FILIAL = @CD_FILIAL
                      AND EST_PROD_TRANSF.DT_TRANSF >= @DT_PROC
                      AND EST_PROD_TRANSF_IT.CD_PROD = @CD_PROD
                      AND ROUND(EST_PROD_TRANSF_IT.VLR_CUSTO, 2) <> @VLR_PROD_CUSTO;

--Pre-fatura pendente
                UPDATE EST_PED_VD_IT
                  SET
                      EST_PED_VD_IT.VLR_CUSTO_ACERTO = @VLR_PROD_CUSTO
                FROM EST_PED_VD
                     INNER JOIN EST_PED_VD_IT ON EST_PED_VD.CD_EMP = EST_PED_VD_IT.CD_EMP
                                                 AND EST_PED_VD.CD_FILIAL = EST_PED_VD_IT.CD_FILIAL
                                                 AND EST_PED_VD.CD_PED = EST_PED_VD_IT.CD_PED
                     INNER JOIN EST_PED_VD_PENDENCIA ON EST_PED_VD.CD_EMP = EST_PED_VD_PENDENCIA.CD_EMP
                                                        AND EST_PED_VD.CD_FILIAL = EST_PED_VD_PENDENCIA.CD_FILIAL
                                                        AND EST_PED_VD.CD_PED = EST_PED_VD_PENDENCIA.CD_PED
                WHERE
                      EST_PED_VD.CD_EMP = @CD_EMP
                      AND EST_PED_VD.CD_FILIAL = @CD_FILIAL
                      AND EST_PED_VD.DT_EMI_PED >= @DT_PROC
                      AND EST_PED_VD_IT.CD_PROD = @CD_PROD
                      AND ROUND(EST_PED_VD_IT.VLR_CUSTO, 2) <> @VLR_PROD_CUSTO;
                DECLARE @CD_NF INT;
                DECLARE @CD_FILIAL_DEST INT;
                DECLARE cNFPend CURSOR FAST_FORWARD READ_ONLY
                FOR SELECT
                           EST_NF_ENT_IT.CD_FILIAL
                         , EST_NF_ENT_IT.CD_NF
                    FROM
                         EST_NF_ENT
                         INNER JOIN EST_NF_ENT_IT ON EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
                                                     AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
                                                     AND EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF
                         INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP
                                                                    AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST
                                                                    AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT
                         INNER JOIN GLB_MOV_OP ON EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
                    WHERE EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP = @CD_EMP
                          AND EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG = @CD_FILIAL
                          AND EST_NF_ENT.DT_ENT >= @DT_PROC
                          AND EST_NF_ENT_IT.CD_PROD = @CD_PROD
                          AND ROUND(EST_NF_ENT_IT.VLR_PRC_CUSTO, 2) <> @VLR_PROD_CUSTO
                          AND GLB_MOV_OP.ATU_EST = 1;
                OPEN cNFPend;
                FETCH NEXT FROM cNFPend INTO @CD_FILIAL_DEST
                                           , @CD_NF;
                WHILE @@FETCH_STATUS = 0
                    BEGIN
		--Replicando para notas fiscais de entrada
                        IF @GrossUp = 10
                            BEGIN
                                UPDATE EST_NF_ENT_IT
                                  SET
                                      EST_NF_ENT_IT.VLR_CUSTO_ACERTO = dbo.UFD_BUSCA_PRECO_PRODUTO_GROSS_UP(CD_EMP, @CD_FILIAL, CD_PROD, 0, 2, CD_FILIAL, @VLR_PROD_CUSTO)
                                FROM EST_NF_ENT_IT
                                WHERE
                                      EST_NF_ENT_IT.CD_EMP = @CD_EMP
                                      AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL_DEST
                                      AND EST_NF_ENT_IT.CD_NF = @CD_NF
                                      AND EST_NF_ENT_IT.CD_PROD = @CD_PROD;
                            END;
                            ELSE
                            BEGIN
                                UPDATE EST_NF_ENT_IT
                                  SET
                                      EST_NF_ENT_IT.VLR_CUSTO_ACERTO = @VLR_PROD_CUSTO
                                FROM EST_NF_ENT_IT
                                WHERE
                                      EST_NF_ENT_IT.CD_EMP = @CD_EMP
                                      AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL_DEST
                                      AND EST_NF_ENT_IT.CD_NF = @CD_NF
                                      AND EST_NF_ENT_IT.CD_PROD = @CD_PROD;
                            END;
                        FETCH NEXT FROM cNFPend INTO @CD_FILIAL_DEST
                                                   , @CD_NF;
                    END;
                CLOSE cNFPend;
                DEALLOCATE cNFPend;
            END;
    END;